<?php
session_start();
include("include/connection.php");

error_reporting(E_ALL);
ini_set('display_errors', 1);

// DELETE admin
if (isset($_GET['delete_id'])) {
    $delete_id = intval($_GET['delete_id']);
    mysqli_query($link, "DELETE FROM admin WHERE id = $delete_id");
    header("Location: all_admin.php");
    exit;
}

$edit_mode = false;
$edit_id = '';
$admin_id = '';
$name = '';
$email = '';
$mobile = '';
$password = '';
$message = '';

// FETCH existing admin for edit
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id']);
    $edit_mode = true;

    $edit_sql = "SELECT * FROM admin WHERE id = $edit_id LIMIT 1";
    $edit_result = mysqli_query($link, $edit_sql);
    if ($edit_result && mysqli_num_rows($edit_result) > 0) {
        $row = mysqli_fetch_assoc($edit_result);
        $admin_id = $row['admin_id'];
        $name = $row['name'];
        $email = $row['email'];
        $mobile = $row['mobile'];
    }
}

// FORM submit
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $admin_id = mysqli_real_escape_string($link, $_POST['admin_id']);
    $name = mysqli_real_escape_string($link, $_POST['name']);
    $email = mysqli_real_escape_string($link, $_POST['email']);
    $mobile = mysqli_real_escape_string($link, $_POST['mobile']);
    $password = mysqli_real_escape_string($link, $_POST['admin_password']);

    if ($edit_mode) {
        // Update admin (password updates only if entered)
        $update_sql = "UPDATE admin SET 
                        admin_id = '$admin_id', 
                        name = '$name', 
                        email = '$email', 
                        mobile = '$mobile'";
        if (!empty($password)) {
            $hashed_pass = password_hash($password, PASSWORD_DEFAULT);
            $update_sql .= ", admin_password = '$hashed_pass'";
        }
        $update_sql .= " WHERE id = $edit_id";

        if (mysqli_query($link, $update_sql)) {
            header("Location: all_admin.php");
            exit;
        } else {
            $message = "<div class='alert alert-danger'>❌ Update failed: " . mysqli_error($link) . "</div>";
        }
    } else {
        // Insert new admin
        $hashed_pass = password_hash($password, PASSWORD_DEFAULT);
        $insert_sql = "INSERT INTO admin (admin_id, name, email, mobile, admin_password) 
                       VALUES ('$admin_id', '$name', '$email', '$mobile', '$password')";
        if (mysqli_query($link, $insert_sql)) {
            $message = "<div class='alert alert-success'>✅ Admin added successfully!</div>";
            $admin_id = $name = $email = $mobile = $password = '';
        } else {
            $message = "<div class='alert alert-danger'>❌ Insert failed: " . mysqli_error($link) . "</div>";
        }
    }
}

include('include/header.php');
include('include/aside.php');
?>

<div class="page-wrapper">
    <div class="page-content">
        <h6 class="mb-0 text-uppercase"><?= $edit_mode ? 'Edit Admin' : 'Add Admin' ?></h6>
        <hr/>

        <div class="card">
            <div class="card-body p-4">
                <h5 class="mb-4"><?= $edit_mode ? 'Edit Existing Admin' : 'Add New Admin' ?></h5>

                <?php if (!empty($message)) echo $message; ?>

                <form class="row g-3" method="POST" action="">
                    <div class="col-md-6">
                        <label for="admin_id" class="form-label">Admin ID</label>
                        <input type="text" class="form-control" id="admin_id" name="admin_id"
                            placeholder="Enter admin ID" value="<?= htmlspecialchars($admin_id) ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label for="name" class="form-label">Full Name</label>
                        <input type="text" class="form-control" id="name" name="name"
                            placeholder="Enter full name" value="<?= htmlspecialchars($name) ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email"
                            placeholder="Enter email address" value="<?= htmlspecialchars($email) ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label for="mobile" class="form-label">Mobile</label>
                        <input type="text" class="form-control" id="mobile" name="mobile"
                            placeholder="Enter mobile number" value="<?= htmlspecialchars($mobile) ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label for="admin_password" class="form-label">
                            <?= $edit_mode ? 'New Password (leave blank to keep same)' : 'Password' ?>
                        </label>
                        <input type="password" class="form-control" id="admin_password" name="admin_password"
                            placeholder="<?= $edit_mode ? 'Enter new password if changing' : 'Enter password' ?>">
                    </div>

                    <div class="col-12 mt-3">
                        <button type="submit" class="btn btn-primary px-4">
                            <?= $edit_mode ? 'Update Admin' : 'Add Admin' ?>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('include/footer.php'); ?>
